# -*- coding: utf-8 -*-
"""
Created on Tue Apr 13 08:54:25 2021

@author: s168562

Script to analyze and plot the Holst straining data (electromechanical analysis).

For this version, I tried to improve the looks of the plots:
    - Made them of size 6.5 x 4.5 cm instead of 10 x 7 inch (suitable for use at 100%)
    - Set font size to 8
    - Removed box around legend
    - Removed errors from the gauge factor calculations (GF1_Rini, GF1_R0)
    - Output pdf & tiff
    - Smaller lines
    - Transparent
"""
### Prerequisites
import pandas as pd
import matplotlib.pyplot as plt
import numpy as np
from collections import OrderedDict
import os # for file paths
from cycler import cycler # for plot color maps
# import sys
# sys.path.append(os.getcwd())
os.chdir(r"C:\Users\s168562\OneDrive - TU Eindhoven\PhD\1_StretchableGink\Data_analysis\Holst_straining\Analysis")
from cyclic_functions import read_data, calc_cycles
#import ggplot

### Enter file details
headerline_ST = 123
headerline_EU = 126
filepath = r"C:\Users\s168562\OneDrive - TU Eindhoven\PhD\1_StretchableGink\Data_analysis\Holst_straining\Raw" # r to escape the backslashes
filename_ST = "20201112-18-11_ST604_LH-PU14 1000x_20_2021-01-25_08.09.26#M01.txt"
filename_EU = "20201112-5-11_LH-PU14_EU94_1000x_20_2021-06-09_12.08.44#M01.txt"
nr_cycles = 1000
max_strain = 0.2 # maximum strain ratio used (percentage = max_strain*100)
min_strain = 0 # min strain used.
outpath = r"C:\Users\s168562\OneDrive - TU Eindhoven\PhD\1_StretchableGink\Data_analysis\Holst_straining\Analysis\Figures\Improved"
remove_first_point = False # Set to True to remove the first data point from the averaged data. (== R0)
outpathfull = r"C:\Users\s168562\OneDrive - TU Eindhoven\PhD\1_StretchableGink\Data_analysis\Holst_straining\Analysis\Figures\Improved\ST-EU_metbrewer"
no_outpath = True # Don't make individual folders for both substrates

### Make odir
if not os.path.exists(outpathfull):
        os.makedirs(outpathfull)

### Read data
(straining_df_ST, Rini_ST, sampleID_ST, mat_ST, length_ST, 
width_ST, linewidth_ST, outpathfull_ST) = read_data(
    filename_ST, filepath, headerline_ST, outpath, nr_cycles, max_strain, 
              min_strain, no_outpath);
    
(straining_df_EU, Rini_EU, sampleID_EU, mat_EU, length_EU, 
width_EU, linewidth_EU, outpathfull_EU) = read_data(
    filename_EU, filepath, headerline_EU, outpath, nr_cycles, max_strain, 
              min_strain, no_outpath);

### Calculations
(straining_df_ST, straining100_df_ST, straining10_df_ST, strain_series_max_ST, 
            strain_series_max2_ST, strain_series_min_ST, strain_series_min2_ST,
            strain_series_residual_strain_ST
            ) = calc_cycles(
    straining_df_ST, nr_cycles, length_ST, max_strain, min_strain, Rini_ST,
                remove_first_point);
                
(straining_df_EU, straining100_df_EU, straining10_df_EU, strain_series_max_EU, 
            strain_series_max2_EU, strain_series_min_EU, strain_series_min2_EU,
            strain_series_residual_strain_EU
            ) = calc_cycles(
    straining_df_EU, nr_cycles, length_EU, max_strain, min_strain, Rini_EU,
                remove_first_point);

# Save the minimum R value before cycle 1 to use for normalization
Rmin1_EU = strain_series_min_EU.values[0]  
Rmin1_ST = strain_series_min_ST.values[0]   
straining_df_ST['Resist_A_norm'] = straining_df_ST['Resist_A']/Rmin1_ST         
straining_df_EU['Resist_A_norm'] = straining_df_EU['Resist_A']/Rmin1_EU    

### Plots
## Plot prerequisites
straining_df_ST['Labels'] = straining_df_ST['Cycle_nr'].values
straining_df_ST['Labels'] = straining_df_ST['Labels'].astype(str)
straining_df_EU['Labels'] = straining_df_EU['Cycle_nr'].values
straining_df_EU['Labels'] = straining_df_EU['Labels'].astype(str)

plt.style.use('default') # default, ggplot, seaborn-*, dark_background, fivethirtyeight
plt.rcParams['font.size'] = 8 # set plot font size matplotlib
cm = 1/2.54  # convert centimeters to inches
from matplotlib.patches import Patch # for manual legend entries
from matplotlib.lines import Line2D # for manual legend entries
### Default sans-serif fonts:
# plt.rcParams['font.sans-serif'] = ['DejaVu Sans',
#  'Bitstream Vera Sans',
#  'Computer Modern Sans Serif',
#  'Lucida Grande',
#  'Verdana',
#  'Geneva',
#  'Lucid',
#  'Arial',
#  'Helvetica',
#  'Avant Garde',
#  'sans-serif']
plt.rcParams['font.sans-serif'] = ['sans-serif',
                                   'sans-serif',
                                   'DejaVu Sans',
 'Bitstream Vera Sans',
 'Computer Modern Sans Serif',
 'Lucida Grande',
 'Verdana',
 'Geneva',
 'Lucid',
 'Arial',
 'Helvetica',
 'Avant Garde']

#plt.style.available()
# The palette with black:
cbbPalette = ["#000000", "#E69F00", "#56B4E9", "#009E73", "#F0E442", "#0072B2", "#D55E00", "#CC79A7"]
cbPalblue = ["#f0f9e8", "#bae4bc", "#7bccc4", "#43a2ca","#0868ac"]
cbPalblueyellow = ["#ffffcc", "#a1dab4", "#41b6c4", "#2c7fb8","#253494"]
cbPalVivid_correctorder = ["#999999", "#AF1B3F", "#F4A698", "#262626", "#6BAA75", "#255C99", "#7EA3CC"]
cbPalVivid = ["#999999", "#AF1B3F", "#F4A698", "#255C99", "#7EA3CC", "#262626", "#6BAA75"]
TUred = "#C81919"

## set color map (only works when first manually running the script palettes.py stored here:)
# C:\Users\s168562\OneDrive - TU Eindhoven\PhD\Code general\MetBrewer-main\MetBrewer-main\Python\met_brewer
colormap = met_brew(name="OKeeffe1", n=4, brew_type="continuous")
colormap6 = met_brew(name="OKeeffe1", n=6, brew_type="continuous")

# Set font to Latex
# from matplotlib import rc
# rc('font', **{'family':'serif','serif':['Palatino']})
# rc('text', usetex=True)



#### Plot normalized resistance over time
plt.figure(figsize= [7.2*cm, 4.95*cm])
plt.plot(straining_df_EU['Time'], straining_df_EU['Resist_A']/Rmin1_EU,
         color = colormap[3], linewidth = 2, label = "EU94")
plt.plot(straining_df_ST['Time'], straining_df_ST['Resist_A']/Rmin1_ST,
         color = colormap[1], linewidth = 2, label = "ST604")
ax = plt.axes()
ax.set_ylim(1, 5)
ax.set_yticks([1, 2, 3, 4, 5])
ax.tick_params(axis="both",direction="in", left="off",labelleft="on", right = "on",
               top = "on")
ax.set_facecolor("white")
plt.legend(fontsize = 'small', loc = 'upper right', frameon = True, framealpha = 1,
           edgecolor = 'white')
plt.xlabel(r'Time [s]')
plt.ylabel(r'$R/R_0$')
figurepath_tiff = os.path.join(outpathfull, "RvsTime_norm.tiff")
figurepath_pdf = os.path.join(outpathfull, "RvsTime_norm.pdf")
plt.savefig(figurepath_tiff, dpi = 300, bbox_inches='tight', transparent = True)
plt.savefig(figurepath_pdf, dpi = 300, bbox_inches='tight', transparent = True)
plt.show()

#### Plot normalized resistance vs cycle
plt.figure(figsize= [7.2*cm, 4.95*cm])
plt.plot(straining_df_EU['Cycle_nr'], straining_df_EU['Resist_A']/Rmin1_EU,
         color = colormap[3], linewidth = 2, label = "EU94")
plt.plot(straining_df_ST['Cycle_nr'], straining_df_ST['Resist_A']/Rmin1_ST,
         color = colormap[1], linewidth = 2, label = "ST604")
ax = plt.axes()
ax.set_ylim(1, 5)
ax.set_yticks([1, 2, 3, 4, 5])
ax.set_xticks([0, 250, 500, 750, 1000])
ax.tick_params(axis="both",direction="in", left="off",labelleft="on", right = "on",
               top = "on")
ax.set_facecolor("white")
plt.legend(fontsize = 'small', loc = 'upper right', frameon = True, framealpha = 1,
           edgecolor = 'white') # solution to have no visible frame but still a white background
plt.xlabel(r'Cycle')
plt.ylabel(r'$R/R_0$')
figurepath_tiff = os.path.join(outpathfull, "RvsCycles_norm.tiff")
figurepath_pdf = os.path.join(outpathfull, "RvsCycles_norm.pdf")
plt.savefig(figurepath_pdf, dpi = 300, bbox_inches='tight', transparent = True)
plt.savefig(figurepath_tiff, dpi = 300, bbox_inches='tight', transparent = True)
plt.show()

#### Plot normalized min/max resistance over time
plt.figure(figsize= [7.2*cm, 4.95*cm])
plt1, = plt.plot(straining_df_EU['Time'][straining_df_EU['Max_pos']], 
         straining_df_EU['Resist_A_norm'][straining_df_EU['Max_pos']],
         color = colormap[3], linewidth = 2, label = r'EU94')
plt2, = plt.plot(straining_df_EU['Time'][straining_df_EU['Min_pos']], 
         straining_df_EU['Resist_A_norm'][straining_df_EU['Min_pos']],
         color = colormap[3], linewidth = 2, linestyle = 'dashed',)
plt3, = plt.plot(straining_df_ST['Time'][straining_df_ST['Max_pos']], 
         straining_df_ST['Resist_A_norm'][straining_df_ST['Max_pos']],
         color = colormap[1], linewidth = 2, label = r'ST604')
plt4, = plt.plot(straining_df_ST['Time'][straining_df_ST['Min_pos']], 
         straining_df_ST['Resist_A_norm'][straining_df_ST['Min_pos']],
         color = colormap[1], linewidth = 2, linestyle = 'dashed') #, label = r'0$\%$ strain'
ax = plt.axes()
ax.set_ylim(1, 5)
ax.set_yticks([1, 2, 3, 4, 5])
ax.tick_params(axis="both",direction="in", left="off",labelleft="on", right = "on",
               top = "on")
ax.set_facecolor("white")
legend_elements = [plt1, plt3, 
                   Line2D([0], [0], color='black', lw=2, label='Max value'),
                   Line2D([0], [0], color='black', lw=2, linestyle = 'dashed', label='Min value')]
plt.legend(handles = legend_elements, loc = 'upper right', fontsize = 'small', 
           frameon = True, framealpha = 1, edgecolor = 'white')
plt.xlabel(r'Time [s]')
plt.ylabel(r'$R/R_0$')
figurepath_tiff = os.path.join(outpathfull, "RvsCycles_minmax_norm.tiff")
figurepath_pdf = os.path.join(outpathfull, "RvsCycles_minmax_norm.pdf")
plt.savefig(figurepath_tiff, dpi = 300, bbox_inches='tight', transparent = True)
plt.savefig(figurepath_pdf, dpi = 300, bbox_inches='tight', transparent = True)
plt.show()

#### Plot normalized min/max resistance vs cycle
plt.figure(figsize= [7.2*cm, 4.95*cm])
plt1, = plt.plot(straining_df_EU['Cycle_nr'][straining_df_EU['Max_pos']], 
         straining_df_EU['Resist_A_norm'][straining_df_EU['Max_pos']],
         color = colormap[3], linewidth = 2, label = r'EU94')
plt2, = plt.plot(straining_df_EU['Cycle_nr'][straining_df_EU['Min_pos']], 
         straining_df_EU['Resist_A_norm'][straining_df_EU['Min_pos']],
         color = colormap[3], linewidth = 2, linestyle = 'dashed',)
plt3, = plt.plot(straining_df_ST['Cycle_nr'][straining_df_ST['Max_pos']], 
         straining_df_ST['Resist_A_norm'][straining_df_ST['Max_pos']],
         color = colormap[1], linewidth = 2, label = r'ST604')
plt4, = plt.plot(straining_df_ST['Cycle_nr'][straining_df_ST['Min_pos']], 
         straining_df_ST['Resist_A_norm'][straining_df_ST['Min_pos']],
         color = colormap[1], linewidth = 2, linestyle = 'dashed') #, label = r'0$\%$ strain'
ax = plt.axes()
ax.set_ylim(1, 5)
ax.set_yticks([1, 2, 3, 4, 5])
ax.set_xticks([0, 250, 500, 750, 1000])
ax.tick_params(axis="both",direction="in", left="off",labelleft="on", right = "on",
               top = "on")
ax.set_facecolor("white")
legend_elements = [plt1, plt3, 
                   Line2D([0], [0], color='black', lw=2, label='Max value'),
                   Line2D([0], [0], color='black', lw=2, linestyle = 'dashed', label='Min value')]
plt.legend(handles = legend_elements, loc = 'center right', fontsize = 'small', 
           frameon = True, framealpha = 1, edgecolor = 'white')
plt.xlabel(r'Cycle')
plt.ylabel(r'$R/R_0$')
figurepath_tiff = os.path.join(outpathfull, "RvsCycles_minmax_norm.tiff")
figurepath_pdf = os.path.join(outpathfull, "RvsCycles_minmax_norm.pdf")
plt.savefig(figurepath_tiff, dpi = 300, bbox_inches='tight', transparent = True)
plt.savefig(figurepath_pdf, dpi = 300, bbox_inches='tight', transparent = True)
plt.show()

### Individual cycles with strain on second axis
## Cycle 1000 with strain on second y axis
plotcycles = [1000]
plt.figure(figsize= [7.2*cm, 4.95*cm])
fig,ax = plt.subplots(figsize= [7.2*cm, 4.95*cm])
lns1a = ax.plot(straining_df_EU['Cycle_time'][straining_df_EU['Cycle_nr'].isin(plotcycles)], 
         straining_df_EU['Resist_A_norm'][straining_df_EU['Cycle_nr'].isin(plotcycles)],
         color = colormap[3], linewidth = 2, label = 'EU94')
lns1b = ax.plot(straining_df_ST['Cycle_time'][straining_df_ST['Cycle_nr'].isin(plotcycles)], 
         straining_df_ST['Resist_A_norm'][straining_df_ST['Cycle_nr'].isin(plotcycles)],
         color = colormap[1], linewidth = 2, label = 'ST604')
ax.tick_params(axis="x",direction="in", left="off", top="on")
ax.tick_params(axis="y",direction="in")
ax.set_facecolor("white")
ax.set_xlabel(r'Time [s]')
ax.set_ylabel(r'$R/R_0$')
ax.set_ylim(1, 5)
# ax.set_yticks([2.5, 3, 3.5, 4, 4.5])
ax.set_xlim(-0.3,6)
# second axis
ax2 = ax.twinx()
lns2 = ax2.plot(straining_df_EU['Cycle_time'][straining_df_EU['Cycle_nr'].isin(plotcycles)], 
         100*straining_df_EU['Strain'][straining_df_EU['Cycle_nr'].isin(plotcycles)],
         color = cbPalVivid[0], linewidth = 2, linestyle = 'dashed', label = 'Strain')
ax2.set_ylabel(r'Strain [%]')
ax2.tick_params(axis="y",direction="in")
ax2.set_yticks([0, 5, 10, 15, 20])
lns = lns1a + lns1b + lns2
labs = [l.get_label() for l in lns]
# ax.legend(lns, labs, loc='lower center', borderaxespad=1, 
#           ncol = 2, bbox_to_anchor = (0.5, -0.4), fontsize = 'small',
#           frameon = False)
plt.legend(lns, labs, loc = 'upper right', fontsize = 'small', 
           frameon = True, framealpha = 1, edgecolor = 'white')
figurepath_pdf = os.path.join(outpathfull, "RCycles1000_R_strain.pdf")
figurepath_tiff = os.path.join(outpathfull, "RCycles1000_R_strain.tiff")
plt.savefig(figurepath_tiff, dpi = 300, bbox_inches='tight', transparent = True)
plt.savefig(figurepath_pdf, dpi = 300, bbox_inches='tight', transparent = True)
plt.show()

## Cycles 1-5 with strain on second y axis
plotcycles = [1, 2, 3, 4, 5]
plt.figure(figsize= [7.2*cm, 4.95*cm])
fig,ax = plt.subplots(figsize= [7.2*cm, 4.95*cm])
lns1a = ax.plot(straining_df_EU['Time'][straining_df_EU['Cycle_nr'].isin(plotcycles)], 
         straining_df_EU['Resist_A_norm'][straining_df_EU['Cycle_nr'].isin(plotcycles)],
         color = colormap[3], linewidth = 2, label = 'EU94')
lns1b = ax.plot(straining_df_ST['Time'][straining_df_ST['Cycle_nr'].isin(plotcycles)], 
         straining_df_ST['Resist_A_norm'][straining_df_ST['Cycle_nr'].isin(plotcycles)],
         color = colormap[1], linewidth = 2, label = 'ST604')
ax.tick_params(axis="x",direction="in", left="off", top="on")
ax.tick_params(axis="y",direction="in")
ax.set_facecolor("white")
ax.set_xlabel(r'Time [s]')
ax.set_ylabel(r'$R/R_0$')
ax.set_ylim(1, 5)
# ax.set_yticks([2.5, 3, 3.5, 4, 4.5])
# ax.set_xlim(-0.3,6)
# second axis
ax2 = ax.twinx()
lns2 = ax2.plot(straining_df_EU['Time'][straining_df_EU['Cycle_nr'].isin(plotcycles)], 
         100*straining_df_EU['Strain'][straining_df_EU['Cycle_nr'].isin(plotcycles)],
         color = cbPalVivid[0], linewidth = 2, linestyle = 'dashed', label = 'Strain')
ax2.set_ylabel(r'Strain [%]')
ax2.tick_params(axis="y",direction="in")
ax2.set_yticks([0, 5, 10, 15, 20])
lns = lns1a + lns1b + lns2
labs = [l.get_label() for l in lns]
# ax.legend(lns, labs, loc='lower center', borderaxespad=1, 
#           ncol = 2, bbox_to_anchor = (0.5, -0.4), fontsize = 'small',
#           frameon = False)
plt.legend(lns, labs, loc = 'lower right', fontsize = 'small', 
           frameon = True, framealpha = 1, edgecolor = 'white')
figurepath_pdf = os.path.join(outpathfull, "RCycles1-5_R_strain.pdf")
figurepath_tiff = os.path.join(outpathfull, "RCycles1-5_R_strain.tiff")
plt.savefig(figurepath_tiff, dpi = 300, bbox_inches='tight', transparent = True)
plt.savefig(figurepath_pdf, dpi = 300, bbox_inches='tight', transparent = True)
plt.show()